<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    public function index() {
        $pageName = 'Profile';
        return view('user.profile.index', compact('pageName'));
    }

    public function changePassword() {
        $pageName = 'Profile';
        return view('user.profile.change-password', compact('pageName'));
    }

    public function passwordUpdate(Request $request) {
        $request->validate([
            'current_password' => 'required',
            'password' => 'required | string | min:6 | max:32 | confirmed'
        ]);
        $user = User::where('id', auth()->user()->id)->first();
        if (Hash::check($request->current_password, $user->password)) {
            $user->update([
                'password' => Hash::make($request->password)
            ]);
            return back()->with('success', 'Updated Successfully');
        }else{
            return back()->with('notMatch', 'Current password not match');
        }
    }
}
