@extends('user.layouts.app')
@section('styles')
    <title>Profile</title>
    <style>
        .profile[data-v-abcfbe96] {
            min-height: calc(100vh - 120px);
            padding: 20px;
            border-radius: var(--radius_s, 6px);
            border: 1px solid var(--stroke-light-grey);
            background: var(--bg-white);
            box-shadow: 0 3px 4px 0 var(--shadow-color);
        }

        .profile__content[data-v-abcfbe96] {
    max-width: 500px;
    padding-bottom: 15px;
    border-bottom: 1px solid var(--stroke-light-grey);
}
.profile__content--header[data-v-abcfbe96] {
    margin-bottom: 30px;
}
.profile__content--header>a[data-v-abcfbe96] {
    display: flex;
    align-items: center;
    gap: 10px;
    color: var(--black-color);
    font-family: Inter,sans-serif;
    font-size: 14px;
    font-style: normal;
    font-weight: 500;
    line-height: 20px;
    cursor: pointer;
}
a:not([class]) {
    text-decoration-skip-ink: auto;
}
.profile__content--header>a[data-v-abcfbe96] svg {
    transform: rotate(270deg);
}
.change-password[data-v-1cefa171] {
    margin: 0 auto;
    max-width: 500px;
    width: 100%;
}
.change-password[data-v-1cefa171] .base-label {
    margin-top: 20px;
    margin-bottom: 20px;
    width: 100%;
    max-width: 100%;
}
.base-label[data-v-499d9965] {
    position: relative;
    display: block;
    margin-top: 10px;
    margin-bottom: 10px;
    width: 100%;
    max-width: 300px;
}
.base-label__content[data-v-499d9965] {
    width: 100%;
}
.base-input__content[data-v-ce1dfc31] {
    position: relative;
    display: block;
    padding-left: 16px;
    padding-right: 16px;
    width: 100%;
    height: 50px;
    border: 1px solid var(--bg, #f5f5f5);
    border-radius: 6px;
    background: var(--bg, #f5f5f5);
    transition: .3s;
}
.base-input input[data-v-ce1dfc31] {
    position: absolute;
    left: 16px;
    bottom: 10px;
    width: calc(100% - 32px);
    font-size: 16px;
    font-style: normal;
    font-weight: 400;
    line-height: 24px;
    color: var(--black-color, #252f4a);
    transition-duration: .3s;
    background: transparent;
    border: none;
}
.base-input__icon--close[data-v-ce1dfc31], .base-input__icon.password[data-v-ce1dfc31] {
    cursor: pointer;
}
.base-input__icon.right[data-v-ce1dfc31] {
    right: 16px;
}
.base-input__icon[data-v-ce1dfc31] {
    position: absolute;
    right: 10px;
    bottom: 0;
    top: 0;
    margin: auto;
    display: flex;
    justify-content: center;
    align-items: center;
    width: 24px;
    height: 24px;
}
.base-input__icon.password svg[data-v-ce1dfc31] {
    height: 24px;
    width: 24px;
}
.change-password[data-v-1cefa171] .base-button {
    width: 100%;
    max-width: 100%;
}
.base-button[data-v-7051bef3] {
    display: inline-flex;
    padding: 15px 36px;
    justify-content: center;
    align-items: center;
    gap: 10px;
    border-radius: 6px;
    background: var(--main-color, #1b84ff);
    font-size: 16px;
    font-style: normal;
    font-weight: 400;
    line-height: 20px;
    text-align: center;
    color: var(--text-white-color, #ffffff);
    border: none;
    cursor: pointer;
    transition-duration: .6s;
}
    </style>
@endsection
@section('content')
    <div data-v-70d36bba="" class="base-layout__content">
        <div data-v-abcfbe96="" data-v-70d36bba="" class="profile">
            <div data-v-abcfbe96="" class="profile__content">
                <div data-v-abcfbe96="" class="profile__content--header"><a data-v-abcfbe96="" href="{{ route('user.profile.index') }}"><svg data-v-abcfbe96=""
                            xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                            fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M3.96967 11.7803C4.26256 12.0732 4.73744 12.0732 5.03033 11.7803L9 7.81065L12.9697 11.7803C13.2626 12.0732 13.7374 12.0732 14.0303 11.7803C14.3232 11.4874 14.3232 11.0125 14.0303 10.7197L9.88388 6.57321C9.39573 6.08505 8.60427 6.08505 8.11612 6.57321L3.96967 10.7197C3.67678 11.0125 3.67678 11.4874 3.96967 11.7803Z"
                                fill="#7786A5"></path>
                        </svg> Back </a></div>
                <form data-v-1cefa171="" data-v-abcfbe96="" class="change-password" action="{{ route('user.profile.passwordUpdate') }}" method="POST">
                    @csrf
                    <label data-v-499d9965=""
                        data-v-ce1dfc31="" data-v-1cefa171="" class="base-label base-input"><!---->
                        <div data-v-499d9965="" class="base-label__content">
                            <div data-v-499d9965="" class="base-label__slot">
                                <div data-v-ce1dfc31="" class="base-input__content icon-position-right">
                                    <input data-v-ce1dfc31="" type="password" style="padding-right: 24px;" name="current_password" placeholder="Enter old password">
                                    {{-- <span data-v-ce1dfc31="" class="base-input__placeholder">Old password</span> --}}
                                    <span data-v-ce1dfc31="" class="base-input__icon right password">
                                        <svg data-v-ce1dfc31="" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.99998 5.75C7.12067 5.75 4.61487 7.34785 3.32517 9.70607C3.22494 9.88934 3.22494 10.1106 3.32517 10.2938C4.61485 12.6521 7.12068 14.25 10 14.25C12.8793 14.25 15.3851 12.6522 16.6748 10.2939C16.7751 10.1107 16.7751 9.88945 16.6748 9.70618C15.3852 7.3479 12.8793 5.75 9.99998 5.75ZM2.00913 8.98633C3.55181 6.16553 6.55159 4.25 9.99998 4.25C13.4484 4.25 16.4482 6.16559 17.9909 8.98646C18.3364 9.61821 18.3364 10.3819 17.9909 11.0137C16.4482 13.8345 13.4484 15.75 10 15.75C6.55159 15.75 3.55177 13.8344 2.00911 11.0135C1.66362 10.3818 1.66363 9.61808 2.00913 8.98633ZM10 8.25C9.0335 8.25 8.25 9.0335 8.25 10C8.25 10.9665 9.0335 11.75 10 11.75C10.9665 11.75 11.75 10.9665 11.75 10C11.75 9.0335 10.9665 8.25 10 8.25ZM6.75 10C6.75 8.20507 8.20507 6.75 10 6.75C11.7949 6.75 13.25 8.20507 13.25 10C13.25 11.7949 11.7949 13.25 10 13.25C8.20507 13.25 6.75 11.7949 6.75 10Z" fill="#99A1B7"></path>
                                        </svg>
                                    </span>
                                </div>
                                @error('current_password')
                                    <span style="color:red;">{{ $message }}</span>
                                @enderror
                                @if (session('notMatch'))
                                    <span style="color:red;">{{ session('notMatch') }}</span>
                                @endif
                            </div><!---->
                        </div>
                    </label>

                    <label data-v-499d9965="" data-v-ce1dfc31="" data-v-1cefa171=""
                        class="base-label base-input"><!---->
                        <div data-v-499d9965="" class="base-label__content">
                            <div data-v-499d9965="" class="base-label__slot">
                                <div data-v-ce1dfc31="" class="base-input__content icon-position-right">
                                    <input data-v-ce1dfc31="" type="password" style="padding-right: 24px;" name="password" placeholder="Enter new password">
                                    {{-- <span data-v-ce1dfc31="" class="base-input__placeholder">New password</span> --}}
                                        <span data-v-ce1dfc31="" class="base-input__icon right password">
                                            <svg data-v-ce1dfc31="" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.99998 5.75C7.12067 5.75 4.61487 7.34785 3.32517 9.70607C3.22494 9.88934 3.22494 10.1106 3.32517 10.2938C4.61485 12.6521 7.12068 14.25 10 14.25C12.8793 14.25 15.3851 12.6522 16.6748 10.2939C16.7751 10.1107 16.7751 9.88945 16.6748 9.70618C15.3852 7.3479 12.8793 5.75 9.99998 5.75ZM2.00913 8.98633C3.55181 6.16553 6.55159 4.25 9.99998 4.25C13.4484 4.25 16.4482 6.16559 17.9909 8.98646C18.3364 9.61821 18.3364 10.3819 17.9909 11.0137C16.4482 13.8345 13.4484 15.75 10 15.75C6.55159 15.75 3.55177 13.8344 2.00911 11.0135C1.66362 10.3818 1.66363 9.61808 2.00913 8.98633ZM10 8.25C9.0335 8.25 8.25 9.0335 8.25 10C8.25 10.9665 9.0335 11.75 10 11.75C10.9665 11.75 11.75 10.9665 11.75 10C11.75 9.0335 10.9665 8.25 10 8.25ZM6.75 10C6.75 8.20507 8.20507 6.75 10 6.75C11.7949 6.75 13.25 8.20507 13.25 10C13.25 11.7949 11.7949 13.25 10 13.25C8.20507 13.25 6.75 11.7949 6.75 10Z" fill="#99A1B7"></path>
                                        </svg>
                                    </span>
                                </div>
                                @error('password')
                                    <span style="color:red;">{{ $message }}</span>
                                @enderror
                            </div><!---->
                        </div>
                    </label><label data-v-499d9965="" data-v-ce1dfc31="" data-v-1cefa171=""
                        class="base-label base-input"><!---->
                        <div data-v-499d9965="" class="base-label__content">
                            <div data-v-499d9965="" class="base-label__slot">
                                <div data-v-ce1dfc31="" class="base-input__content icon-position-right"><input
                                        data-v-ce1dfc31="" type="password" style="padding-right: 24px;" name="password_confirmation" placeholder="Repeat password"><span
                                        {{-- data-v-ce1dfc31="" class="base-input__placeholder">Repeat password</span> --}}
                                        <!----><!----><span data-v-ce1dfc31=""
                                        class="base-input__icon right password"><svg data-v-ce1dfc31=""
                                            xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                            viewBox="0 0 20 20" fill="none">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M9.99998 5.75C7.12067 5.75 4.61487 7.34785 3.32517 9.70607C3.22494 9.88934 3.22494 10.1106 3.32517 10.2938C4.61485 12.6521 7.12068 14.25 10 14.25C12.8793 14.25 15.3851 12.6522 16.6748 10.2939C16.7751 10.1107 16.7751 9.88945 16.6748 9.70618C15.3852 7.3479 12.8793 5.75 9.99998 5.75ZM2.00913 8.98633C3.55181 6.16553 6.55159 4.25 9.99998 4.25C13.4484 4.25 16.4482 6.16559 17.9909 8.98646C18.3364 9.61821 18.3364 10.3819 17.9909 11.0137C16.4482 13.8345 13.4484 15.75 10 15.75C6.55159 15.75 3.55177 13.8344 2.00911 11.0135C1.66362 10.3818 1.66363 9.61808 2.00913 8.98633ZM10 8.25C9.0335 8.25 8.25 9.0335 8.25 10C8.25 10.9665 9.0335 11.75 10 11.75C10.9665 11.75 11.75 10.9665 11.75 10C11.75 9.0335 10.9665 8.25 10 8.25ZM6.75 10C6.75 8.20507 8.20507 6.75 10 6.75C11.7949 6.75 13.25 8.20507 13.25 10C13.25 11.7949 11.7949 13.25 10 13.25C8.20507 13.25 6.75 11.7949 6.75 10Z"
                                                fill="#99A1B7"></path>
                                        </svg></span></div>
                            </div><!---->
                        </div>
                    </label><button data-v-7051bef3="" data-v-1cefa171="" class="base-button default">Change
                        password</button></form>
            </div>
        </div>
    </div>
@endsection
