@extends('user.layouts.app')
@section('styles')
    <title>Profile</title>
    <style>
        .profile[data-v-abcfbe96] {
            min-height: calc(100vh - 120px);
            padding: 20px;
            border-radius: var(--radius_s, 6px);
            border: 1px solid var(--stroke-light-grey);
            background: var(--bg-white);
            box-shadow: 0 3px 4px 0 var(--shadow-color);
        }

        .profile__profile[data-v-abcfbe96] {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .profile__profile[data-v-abcfbe96] .base-button {
            width: 44px !important;
            height: 44px !important;
            border-radius: 6px;
            border: 1px solid var(--stroke-light-grey);
            background: var(--bg);
            color: var(--profile-name-color);
        }

        .base-button.action[data-v-7051bef3] {
            padding: 0;
            min-width: 40px;
            height: 40px;
        }

        .base-button[data-v-7051bef3] {
            display: inline-flex;
            padding: 15px 36px;
            justify-content: center;
            align-items: center;
            gap: 10px;
            border-radius: 6px;
            background: var(--main-color, #1b84ff);
            font-size: 16px;
            font-style: normal;
            font-weight: 400;
            line-height: 20px;
            text-align: center;
            color: var(--text-white-color, #ffffff);
            border: none;
            cursor: pointer;
            transition-duration: .6s;
        }

        .profile__profile--info .name[data-v-abcfbe96] {
            display: block;
            color: var(--black-color);
            font-family: Inter, sans-serif;
            font-size: 14px;
            font-style: normal;
            font-weight: 500;
            line-height: 16px;
        }

        .profile__profile--info .email[data-v-abcfbe96] {
            margin-top: 4px;
            display: block;
            color: var(--grey-color);
            font-family: Inter, sans-serif;
            font-size: 12px;
            font-style: normal;
            font-weight: 500;
            line-height: 16px;
        }

        .profile__title[data-v-abcfbe96] {
            margin-top: 30px;
            color: var(--black-color);
            font-family: Inter, sans-serif;
            font-size: 16px;
            font-style: normal;
            font-weight: 600;
            line-height: 20px;
        }

        .profile__content[data-v-abcfbe96] {
            max-width: 500px;
            padding-bottom: 15px;
            border-bottom: 1px solid var(--stroke-light-grey);
        }

        .profile-checkbox[data-v-65c0243c] {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            max-width: 500px;
            margin-bottom: 15px;
            margin-top: 15px;
            cursor: pointer;
        }

        .profile-checkbox .label[data-v-65c0243c] {
            display: flex;
            align-items: flex-start;
            gap: 10px;
        }

        .profile-checkbox[data-v-65c0243c] {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            max-width: 500px;
            margin-bottom: 15px;
            margin-top: 15px;
            cursor: pointer;
        }

        .base-label[data-v-499d9965] {
            position: relative;
            display: block;
            margin-top: 10px;
            margin-bottom: 10px;
            width: 100%;
            max-width: 300px;
        }

        .base-label__content[data-v-499d9965] {
            width: 100%;
        }

        .base-select__content[data-v-e6ea3ef4] {
            position: relative;
        }

        .base-label .el-select {
            width: 100%;
        }

        .base-label[data-v-499d9965] .el-input {
            width: 100%;
        }

        .base-select[data-v-e6ea3ef4] .el-select .el-input.is-focus .el-input__wrapper {
            box-shadow: 0 0 0 1px var(--main-color, #1b84ff) inset !important;
        }

        .base-select[data-v-e6ea3ef4] .el-select .el-input__inner {
            color: var(--black-color, #252f4a) !important;
        }

        .el-input__suffix {
            display: inline-flex;
            white-space: nowrap;
            flex-shrink: 0;
            flex-wrap: nowrap;
            height: 100%;
            text-align: center;
            color: var(--el-input-icon-color, var(--el-text-color-placeholder));
            transition: all var(--el-transition-duration);
            pointer-events: none;
        }

        .el-input__suffix-inner {
            pointer-events: all;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .base-select[data-v-e6ea3ef4] .el-select .el-input__suffix-inner .el-icon {
            color: var(--grey-color, #99a1b7);
        }

        .el-select .el-input .el-select__caret.el-icon {
            position: relative;
            height: inherit;
            z-index: 2;
        }

        .el-select .el-input .el-select__caret.el-icon {
            position: relative;
            height: inherit;
            z-index: 2;
        }

        .el-select .el-input .el-select__caret.is-reverse {
            transform: rotate(-180deg);
        }

        .el-select .el-input .el-select__caret {
            color: var(--el-select-input-color);
            font-size: var(--el-select-input-font-size);
            transition: transform var(--el-transition-duration);
            transform: rotate(0);
            cursor: pointer;
        }

        .el-select .el-input .el-select__caret {
            color: var(--el-select-input-color);
            font-size: var(--el-select-input-font-size);
            transition: transform var(--el-transition-duration);
            transform: rotate(0);
            cursor: pointer;
        }

        .el-input__suffix-inner>:first-child {
            margin-left: 8px;
        }

        .el-icon {
            --color: inherit;
            height: 1em;
            width: 1em;
            line-height: 1em;
            display: inline-flex;
            justify-content: center;
            align-items: center;
            position: relative;
            fill: currentColor;
            color: var(--color);
            font-size: inherit;
        }

        .theme-switch[data-v-879b9191] {
            padding: 0;
            display: flex;
            align-items: center;
            gap: 15px;
            list-style: none;
        }

        li[data-v-07b38dec] {
            cursor: pointer;
            position: relative;
        }

        .theme-switch__item--light>div[data-v-07b38dec] {
            background: #fff;
        }

        li>div[data-v-07b38dec] {
            min-width: 56px;
            min-height: 56px;
            border-radius: 6px;
            transition: all .3s;
        }

        .profile-checkbox .action[data-v-65c0243c] {
            display: block;
            color: var(--main-color);
            font-family: Inter, sans-serif;
            font-size: 14px;
            font-style: normal;
            font-weight: 500;
            line-height: 20px;
        }
    </style>
@endsection
@section('content')
    <div data-v-70d36bba="" class="base-layout__content">
        <div data-v-abcfbe96="" data-v-70d36bba="" class="profile">
            <div data-v-abcfbe96="">
                <div data-v-abcfbe96="" class="profile__profile"><button data-v-7051bef3="" data-v-abcfbe96=""
                        class="base-button secondary action">{{ Str::substr(auth()->user()->name, 0, 1) }}</button>
                    <div data-v-abcfbe96="" class="profile__profile--info"><span data-v-abcfbe96=""
                            class="name">{{ auth()->user()->name }}</span><span data-v-abcfbe96=""
                            class="email">{{ auth()->user()->email }}</span></div>
                </div>
                <div data-v-abcfbe96="" class="profile__title"><span data-v-abcfbe96="">Security</span></div>
                <div data-v-abcfbe96="" class="profile__content">
                    <div data-v-65c0243c="" data-v-abcfbe96="" class="profile-checkbox"
                        onclick="return window.location.href='{{ route('user.profile.changePassword') }}'">
                        <div data-v-65c0243c="" class="label"><svg data-v-65c0243c="" width="24" height="24"
                                viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <rect data-v-65c0243c="" width="24" height="24" rx="5" fill="#F1F1F4"></rect>
                                <path data-v-65c0243c="" fill-rule="evenodd" clip-rule="evenodd"
                                    d="M17.864 7.91401C18.1569 8.2069 18.1569 8.68177 17.864 8.97467L10.7529 16.0858C10.46 16.3787 9.98511 16.3787 9.69221 16.0858L6.13666 12.5302C5.84377 12.2373 5.84377 11.7625 6.13666 11.4696C6.42956 11.1767 6.90443 11.1767 7.19732 11.4696L10.2225 14.4948L16.8033 7.91401C17.0962 7.62111 17.5711 7.62111 17.864 7.91401Z"
                                    fill="#99A1B7"></path>
                            </svg><span data-v-65c0243c="">Password</span></div><span data-v-65c0243c=""
                            class="action">Change password</span>
                    </div>
                    <div data-v-65c0243c="" data-v-abcfbe96="" class="profile-checkbox el-tooltip__trigger">
                        <div data-v-65c0243c="" class="label"><svg data-v-65c0243c="" width="24" height="24"
                                viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <rect data-v-65c0243c="" width="24" height="24" rx="5" fill="#F1F1F4"></rect>
                                <!---->
                            </svg><span data-v-65c0243c="">Two-factor authentication via Google Authenticator</span></div>
                        <span data-v-65c0243c="" class="action">Connect</span>
                    </div>
                </div>
                {{-- <div data-v-abcfbe96="">
                    <div data-v-abcfbe96="" class="profile__title"><span data-v-abcfbe96="">Time zone</span></div>
                    <div data-v-abcfbe96="" class="profile__content">
                        <div data-v-499d9965="" data-v-e6ea3ef4="" data-v-abcfbe96=""
                            class="base-label base-select move-placeholder profile-timezone"><!---->
                            <div data-v-499d9965="" class="base-label__content">
                                <div data-v-499d9965="" class="base-label__slot">
                                    <div data-v-e6ea3ef4="" class="base-select__content"><!----><!----><!---->
                                        <div data-v-e6ea3ef4="" class="el-select el-select--large">
                                            <div class="select-trigger el-tooltip__trigger el-tooltip__trigger"
                                                aria-describedby="el-id-2105-15">
                                                <!--v-if--><!-- fix: https://github.com/element-plus/element-plus/issues/11415 --><!--v-if-->
                                                <div class="el-input el-input--large el-input--suffix is-focus">
                                                    <!-- input --><!-- prepend slot --><!--v-if-->
                                                    <div class="el-input__wrapper" tabindex="-1">
                                                        <!-- prefix slot --><!--v-if-->
                                                        <input class="el-input__inner" type="text" autocomplete="off"
                                                            tabindex="0" placeholder="Asia/Dhaka"
                                                            id="el-id-2105-16"><!-- suffix slot --><span
                                                            class="el-input__suffix"><span class="el-input__suffix-inner"><i
                                                                    class="el-icon el-select__caret el-select__icon is-reverse"><svg
                                                                        xmlns="http://www.w3.org/2000/svg"
                                                                        viewBox="0 0 1024 1024">
                                                                        <path fill="currentColor"
                                                                            d="M831.872 340.864 512 652.672 192.128 340.864a30.592 30.592 0 0 0-42.752 0 29.12 29.12 0 0 0 0 41.6L489.664 714.24a32 32 0 0 0 44.672 0l340.288-331.712a29.12 29.12 0 0 0 0-41.728 30.592 30.592 0 0 0-42.752 0z">
                                                                        </path>
                                                                    </svg></i><!--v-if--><!--v-if--><!--v-if--><!--v-if--><!--v-if--><!--v-if--></span></span>
                                                    </div>
                                                    <!-- append slot --><!--v-if-->

                                                    <div id="el-popper-container-1154">
                                                        <div class="el-popper is-pure is-light el-select__popper"
                                                            tabindex="-1" aria-hidden="false" role="tooltip"
                                                            id="el-id-1154-0" data-popper-reference-hidden="false"
                                                            data-popper-escaped="false"
                                                            data-popper-placement="bottom-start"
                                                            style="z-index: 2008; position: absolute; inset: 51px auto auto 0;">
                                                            <div class="el-select-dropdown" style="min-width: 300px;">
                                                                <div class="el-scrollbar" style="">
                                                                    <div
                                                                        class="el-select-dropdown__wrap el-scrollbar__wrap el-scrollbar__wrap--hidden-default">
                                                                        <ul class="el-scrollbar__view el-select-dropdown__list"
                                                                            style=""><!--v-if-->
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-12:00 —
                                                                                        Baker Island, Howland Island
                                                                                        (USA)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-11:00 —
                                                                                        American Samoa, Niue</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-10:00 —
                                                                                        Hawaii, Tahiti</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-09:30 —
                                                                                        Marquesas Islands</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-09:00 —
                                                                                        Alaska</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-08:00 — Los
                                                                                        Angeles, Vancouver, Pacific Time
                                                                                        (USA &amp; Canada)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-07:00 —
                                                                                        Denver, Phoenix, Mountain Time (USA
                                                                                        &amp; Canada)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-06:00 —
                                                                                        Chicago, Mexico City, Central Time
                                                                                        (USA &amp; Canada)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-05:00 — New
                                                                                        York, Toronto, Bogotá, Eastern Time
                                                                                        (USA &amp; Canada)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-04:00 —
                                                                                        Caracas, Santiago, Atlantic Time
                                                                                        (Canada)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-03:30 —
                                                                                        Newfoundland (Canada)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-03:00 —
                                                                                        Buenos Aires, São Paulo,
                                                                                        Montevideo</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-02:00 —
                                                                                        South Georgia &amp; South Sandwich
                                                                                        Islands</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC-01:00 —
                                                                                        Azores, Cape Verde</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC±00:00 —
                                                                                        Static</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC±00:00 —
                                                                                        London, Lisbon, Dublin, Reykjavik
                                                                                        (GMT)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+01:00 —
                                                                                        Berlin, Paris, Rome, Madrid, Central
                                                                                        European Time</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+02:00 —
                                                                                        Kyiv, Athens, Cairo, Tel Aviv,
                                                                                        Eastern European Time</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item hover">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+03:00 —
                                                                                        Moscow, Istanbul, Nairobi,
                                                                                        Riyadh</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+03:30 —
                                                                                        Tehran</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+04:00 —
                                                                                        Baku, Dubai, Seychelles</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+04:30 —
                                                                                        Kabul</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+05:00 —
                                                                                        Islamabad, Karachi, Maldives</span>
                                                                                </div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+05:30 —
                                                                                        Delhi, Colombo</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+05:45 —
                                                                                        Kathmandu</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item selected">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+06:00 —
                                                                                        Almaty, Bishkek, Dhaka</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+06:30 —
                                                                                        Yangon, Cocos Islands</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+07:00 —
                                                                                        Bangkok, Jakarta, Phnom Penh</span>
                                                                                </div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+08:00 —
                                                                                        Beijing, Hong Kong, Manila,
                                                                                        Perth</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+08:45 —
                                                                                        Western Australia (some
                                                                                        regions)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+09:00 —
                                                                                        Tokyo, Seoul</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+09:30 —
                                                                                        Adelaide, Darwin</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+10:00 —
                                                                                        Sydney, Port Moresby, Solomon
                                                                                        Islands</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+10:30 — Lord
                                                                                        Howe Island (Australia)</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+11:00 —
                                                                                        Nouméa, Honiara</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+12:00 —
                                                                                        Auckland, Suva, Fiji</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+12:45 —
                                                                                        Chatham Islands (New Zealand)</span>
                                                                                </div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+13:00 —
                                                                                        Tonga, Samoa</span></div>
                                                                            </li>
                                                                            <li data-v-e6ea3ef4=""
                                                                                class="el-select-dropdown__item">
                                                                                <div data-v-e6ea3ef4=""
                                                                                    class="base-select__option">
                                                                                    <!----><span
                                                                                        data-v-e6ea3ef4="">UTC+14:00 — Line
                                                                                        Islands (Kiribati)</span></div>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                    <div class="el-scrollbar__bar is-horizontal"
                                                                        style="display: none;">
                                                                        <div class="el-scrollbar__thumb"
                                                                            style="transform: translateX(0%);"></div>
                                                                    </div>
                                                                    <div class="el-scrollbar__bar is-vertical"
                                                                        style="display: none;">
                                                                        <div class="el-scrollbar__thumb"
                                                                            style="transform: translateY(228.148%); height: 54.4843px;">
                                                                        </div>
                                                                    </div>
                                                                </div><!--v-if-->
                                                            </div><span class="el-popper__arrow" data-popper-arrow=""
                                                                style="position: absolute; left: 144px;"></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div><!---->
                            </div>
                        </div>
                    </div>
                </div> --}}

            </div>
        </div>
    </div>
@endsection
