<?php

use App\Http\Controllers\Admin\AdminHomeController;
use App\Http\Controllers\Admin\AdminProfileController;
use App\Http\Controllers\Admin\AdminSettingController;
use App\Http\Controllers\FrontendHomeController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\User\DashboardController;
use App\Http\Controllers\User\ProfileController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

Route::get('/reboot', function () {
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    Artisan::call('config:cache');
    Artisan::call('view:cache');
    // composer dump-autoload
    dd('Done');
});

Auth::routes();

Route::get('/', [FrontendHomeController::class, 'index'])->name('frontend.index');





Route::get('/home', [HomeController::class, 'index'])->name('home');


// Admin Routes
Route::group(['prefix' => 'admin', 'middleware' => ['auth', 'is_admin']], function(){
    Route::get('/dashboard', [AdminHomeController::class, 'index'])->name('admin.dashboard');
    Route::get('/user-list', [AdminHomeController::class, 'userList'])->name('admin.users');
    Route::get('/user/{id}/delete', [AdminHomeController::class, 'deleteUser'])->name('admin.user.delete');


    Route::get('/profile', [AdminProfileController::class, 'index'])->name('admin.profile.index');
    Route::get('/profile/edit', [AdminProfileController::class, 'edit'])->name('admin.profile.edit');
    Route::get('/profile/remove', [AdminProfileController::class, 'remove'])->name('admin.profile.remove');
    Route::post('/profile/update', [AdminProfileController::class, 'update'])->name('admin.profile.update');
    Route::get('/profile/change-password', [AdminProfileController::class, 'password'])->name('admin.profile.password');
    Route::post('/profile/update-password', [AdminProfileController::class, 'updatePassword'])->name('admin.profile.updatePassword');

    // settings route
    Route::get('/general-setting', [AdminSettingController::class, 'generalSetting'])->name('admin.setting.generalSetting');
    Route::post('/general-setting', [AdminSettingController::class, 'generalSettingUpdate'])->name('admin.setting.generalSetting.update');
    Route::get('/meta-setting', [AdminSettingController::class, 'metaSetting'])->name('admin.setting.metaSetting');
    Route::post('/meta-setting', [AdminSettingController::class, 'metaSettingUpdate'])->name('admin.setting.metaSetting.update');




});


Route::group(['middleware' => ['auth', 'is_user']], function(){
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('user.dashboard');
    Route::get('/profile', [ProfileController::class, 'index'])->name('user.profile.index');
    Route::get('/profile/change-password', [ProfileController::class, 'changePassword'])->name('user.profile.changePassword');
    Route::post('/profile/update-password', [ProfileController::class, 'passwordUpdate'])->name('user.profile.passwordUpdate');

});
