<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            transition: opacity ease-in 0.2s;
        }

        body[unresolved] {
            opacity: 0;
            display: block;
            overflow: hidden;
            position: relative;
        }
    </style>

    <meta charset="utf-8">
    <title>Swap.Paykassma</title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">

    <link rel="icon" href="https://swap.paykassma.com/images/favicon.png">
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/app.min.css')); ?>">


</head>

<body>

    <div class="wrapper">
        <header class="app-header">
            <div class="container">
                <div class="header-row">
                    <div class="header-logo">
                        <a href="/" class="logo">
                            <img src="https://swap.paykassma.com/images/dist/logo.svg" alt="Swap.paykassma" width="187" height="24">
                            <img src="https://swap.paykassma.com/images/dist/logo-without-text.svg" alt="Swap.paykassma" width="32" height="24">
                        </a>
                    </div>

                    <div class="header-menu">
                        <nav class="menu-list">
                            <a href="#s-advantages" data-scroll="">Advantages</a>
                            <a href="#our-service" data-scroll="">Our service</a>
                            <a href="#contact-us" data-scroll="">Contact us</a>
                        </nav>
                    </div>

                    <div class="header-telegram">
                        <a class="btn btn-sm check-your-manager--trigger" href="#check-your-manager" data-scroll="">
                            <span>
                                <svg width="20" height="20" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 24 24" fill="currentColor">
                                    <title>shield-outline</title>
                                    <path
                                        d="M21,11C21,16.55 17.16,21.74 12,23C6.84,21.74 3,16.55 3,11V5L12,1L21,5V11M12,21C15.75,20 19,15.54 19,11.22V6.3L12,3.18L5,6.3V11.22C5,15.54 8.25,20 12,21Z">
                                    </path>
                                </svg>
                                Check your manager
                            </span>
                        </a>
                        <a href="#" class="url_telegram_bot btn btn-sm" target="_blank">
                            <span><img src="<?php echo e(asset('assets/frontend/img/telegram.svg')); ?>" alt="Telegram">Contact us in Telegram</span>
                        </a>
                    </div>

                    <div class="header-lang">
                        <button class="current-lang">
                            <img src="<?php echo e(asset('assets/frontend/img/en.svg')); ?>">
                            EN
                        </button>

                        <div class="header-lang-dropdown">
                            <a href="/" class="active lang-link">
                                <img src="<?php echo e(asset('assets/frontend/img/en.svg')); ?>">
                                EN
                            </a>
                            <a href="/ne" class="lang-link">
                                <img src="<?php echo e(asset('assets/frontend/img/ne.svg')); ?>">
                                NE
                            </a>
                            <a href="/bn" class="lang-link">
                                <img src="<?php echo e(asset('assets/frontend/img/bn.svg')); ?>">
                                BN
                            </a>
                            <a href="/si" class="lang-link">
                                <img src="<?php echo e(asset('assets/frontend/img/si.svg')); ?>">
                                SI
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <section class="s-main-window">
            <div class="main-window-bg">
                <img src="<?php echo e(asset('assets/frontend/img/grid.svg')); ?>" alt="">
            </div>

            <div class="container">
                <div class="main-window-row">
                    <div class="main-window-content">
                        <h1>Let's take your processing business to the next level!</h1>
                        <p>We provide the opportunity for teams of traders to work with the best products on the market.
                        </p>
                        <a href="#contact-us" class="btn" data-scroll="">
                            <span>Contact us <img src="<?php echo e(asset('assets/frontend/img/arrow-down.svg')); ?>" alt=""></span>
                        </a>
                    </div>

                    <div class="main-window-img">
                        <img src="<?php echo e(asset('assets/frontend/img/main-illustration.svg')); ?>" alt="">
                    </div>
                </div>
            </div>
        </section>

        <section class="s-advantages" id="s-advantages">
            <div class="container">
                <div class="advantages">
                    <div class="section-title">
                        <h3>Advantages</h3>
                        <h2>We will provide for you</h2>
                    </div>

                    <div class="advantages-grid">
                        <div class="advantage">
                            <img src="<?php echo e(asset('assets/frontend/img/diploma.svg')); ?>" alt="">
                            <h3>Better conditions</h3>
                        </div>

                        <div class="advantage">
                            <img src="<?php echo e(asset('assets/frontend/img/pie-chart.svg')); ?>" alt="">
                            <h3>Large volumes</h3>
                        </div>

                        <div class="advantage">
                            <img src="<?php echo e(asset('assets/frontend/img/card-send.svg')); ?>" alt="">
                            <h3>Instant payments</h3>
                        </div>

                        <div class="advantage">
                            <img src="<?php echo e(asset('assets/frontend/img/wad-of-money.svg')); ?>" alt="">
                            <h3>The most popular payment systems</h3>
                        </div>

                        <div class="advantage">
                            <img src="<?php echo e(asset('assets/frontend/img/calendar.svg')); ?>" alt="">
                            <h3>Flexible work schedule</h3>
                        </div>

                        <div class="advantage">
                            <img src="<?php echo e(asset('assets/frontend/img/medal-star-square.svg')); ?>" alt="">
                            <h3>TOP clients</h3>
                        </div>

                        <div class="advantage">
                            <img src="<?php echo e(asset('assets/frontend/img/dialog.svg')); ?>" alt="">
                            <h3>24/7 support</h3>
                        </div>

                        <div class="advantage accent">
                            <a href="#contact-us" data-scroll=""></a>
                            <img src="<?php echo e(asset('assets/frontend/img/arrow-down.svg')); ?>" alt="">
                            <h3>Contact us</h3>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="s-services" id="our-service">
            <div class="container">
                <div class="services">
                    <div class="services__possibilities">
                        <div class="services__possibilities--item">
                            <h2>
                                Unlock New Earning Opportunities
                            </h2>

                            <div class="card">
                                <h4 class="card--title">What you get:</h4>

                                <ul class="card__list">
                                    <li>
                                        Attractive earning conditions designed to maximize your
                                        profit
                                    </li>
                                    <li>
                                        24/7 support — responsive, experienced, and ready to
                                        assist
                                    </li>
                                    <li>
                                        A smart, intuitive dashboard to manage payouts and track
                                        performance with ease
                                    </li>
                                    <li>
                                        Full transparency at every step — you’re always in control
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="services__possibilities--item">
                            <h2>
                                All-in-one Dashboard
                            </h2>

                            <div class="card card--dashboard">
                                <h4 class="card--title">Everything you need — in one place:</h4>

                                <ul class="card__list">
                                    <li>
                                        Real-time performance monitoring
                                    </li>
                                    <li>
                                        Full control over your payout flow
                                    </li>
                                    <li>
                                        Clear transaction history and request tracking
                                    </li>
                                    <li>
                                        Designed for speed, clarity, and convenience
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <p class="services__description">
                        Partner with SWAP to grow your income through high-yield platforms — backed by powerful
                        tools, expert support, and flexible terms.
                    </p>
                </div>
            </div>
        </section>

        <section class="s-callback" id="contact-us">
            <div class="container">
                <div class="callback">
                    <div class="callback-text">
                        <div class="section-title">
                            <h3>Contact us</h3>
                            <h2>Leave a request and get the most favorable conditions on the market</h2>
                        </div>

                        <p>Fill out the form and our manager will contact you shortly or write to us in Telegram</p>
                    </div>

                    <div class="callback-content">
                        <a href="#"
                            class="url_telegram_bot callback-content__tel-link btn btn-sm" target="_blank">
                            <span><img src="<?php echo e(asset('assets/frontend/img')); ?>/telegram.svg" alt="">Contact us in
                                Telegram</span>
                        </a>

                        <!--                    <div class="callback-content__form">-->
                        <form class="callback-form callback-content__form" novalidate=""
                            onsubmit="handleSubmitForm(this)">
                            <div class="callback-form-success">
                                <img src="<?php echo e(asset('assets/frontend/img')); ?>/success.svg" alt="">
                                <h3>Your application has been successfully sent!</h3>
                            </div>

                            <div class="form-group">
                                <input type="text" name="FullName" class="form-input" placeholder="Full name"
                                    data-clearable="" required="">
                            </div>

                            <div class="form-group">
                                <input type="email" name="Email" class="form-input" placeholder="Email"
                                    data-clearable="" required="">
                            </div>

                            <div class="form-group">
                                <input type="text" name="PhoneNumber" class="form-input"
                                    placeholder="Phone number" data-clearable="" required="">
                            </div>

                            <div class="form-group">
                                <input type="text" name="TelegramUsername" class="form-input"
                                    placeholder="Telegram username, e.g. @username" data-clearable="" required="">
                            </div>

                            <div class="form-group form-group--country">
                                <div class="country-select form-select">
                                    <input type="text" name="Country" class="form-select__input"
                                        data-select-label="country-select" autocomplete="off" novalidate=""
                                        data-clearable="" readonly="" placeholder="Country" required="">
                                    <div class="form-select__trigger">
                                        <img src="<?php echo e(asset('assets/frontend/img')); ?>/angle-down.svg">
                                    </div>

                                    <div class="form-select__field form-input">
                                        <span data-label="country-select"></span>
                                        <label class="form-select__placeholder">Country</label>
                                    </div>

                                    <ul class="form-select__options scrollbar">
                                        <li data-value="India">India</li>
                                        <li data-value="Bangladesh">Bangladesh</li>
                                        <li data-value="Pakistan">Pakistan</li>
                                        <li data-value="Nepal">Nepal</li>
                                        <li data-value="Myanmar">Myanmar</li>
                                        <li data-value="Afghanistan">Afghanistan</li>
                                        <li data-value="Albania">Albania</li>
                                        <li data-value="Algeria">Algeria</li>
                                        <li data-value="American Samoa">American Samoa</li>
                                        <li data-value="Andorra">Andorra</li>
                                        <li data-value="Angola">Angola</li>
                                        <li data-value="Anguilla">Anguilla</li>
                                        <li data-value="Antarctica">Antarctica</li>
                                        <li data-value="Antigua and Barbuda">Antigua and Barbuda</li>
                                        <li data-value="Argentina">Argentina</li>
                                        <li data-value="Armenia">Armenia</li>
                                        <li data-value="Aruba">Aruba</li>
                                        <li data-value="Australia">Australia</li>
                                        <li data-value="Austria">Austria</li>
                                        <li data-value="Azerbaijan">Azerbaijan</li>
                                        <li data-value="Bahamas (the)">Bahamas (the)</li>
                                        <li data-value="Bahrain">Bahrain</li>
                                        <li data-value="Barbados">Barbados</li>
                                        <li data-value="Belarus">Belarus</li>
                                        <li data-value="Belgium">Belgium</li>
                                        <li data-value="Belize">Belize</li>
                                        <li data-value="Benin">Benin</li>
                                        <li data-value="Bermuda">Bermuda</li>
                                        <li data-value="Bhutan">Bhutan</li>
                                        <li data-value="Bolivia (Plurinational State of)">Bolivia (Plurinational State
                                            of)</li>
                                        <li data-value="Bonaire, Sint Eustatius and Saba">Bonaire, Sint Eustatius and
                                            Saba</li>
                                        <li data-value="Bosnia and Herzegovina">Bosnia and Herzegovina</li>
                                        <li data-value="Botswana">Botswana</li>
                                        <li data-value="Bouvet Island">Bouvet Island</li>
                                        <li data-value="Brazil">Brazil</li>
                                        <li data-value="British Indian Ocean Territory (the)">British Indian Ocean
                                            Territory (the)</li>
                                        <li data-value="Brunei Darussalam">Brunei Darussalam</li>
                                        <li data-value="Bulgaria">Bulgaria</li>
                                        <li data-value="Burkina Faso">Burkina Faso</li>
                                        <li data-value="Burundi">Burundi</li>
                                        <li data-value="Cabo Verde">Cabo Verde</li>
                                        <li data-value="Cambodia">Cambodia</li>
                                        <li data-value="Cameroon">Cameroon</li>
                                        <li data-value="Canada">Canada</li>
                                        <li data-value="Cayman Islands (the)">Cayman Islands (the)</li>
                                        <li data-value="Central African Republic (the)">Central African Republic (the)
                                        </li>
                                        <li data-value="Chad">Chad</li>
                                        <li data-value="Chile">Chile</li>
                                        <li data-value="China">China</li>
                                        <li data-value="Christmas Island">Christmas Island</li>
                                        <li data-value="Cocos (Keeling) Islands (the)">Cocos (Keeling) Islands (the)
                                        </li>
                                        <li data-value="Colombia">Colombia</li>
                                        <li data-value="Comoros (the)">Comoros (the)</li>
                                        <li data-value="Congo (the Democratic Republic of the)">Congo (the Democratic
                                            Republic of the)</li>
                                        <li data-value="Congo (the)">Congo (the)</li>
                                        <li data-value="Cook Islands (the)">Cook Islands (the)</li>
                                        <li data-value="Costa Rica">Costa Rica</li>
                                        <li data-value="Croatia">Croatia</li>
                                        <li data-value="Cuba">Cuba</li>
                                        <li data-value="Curaçao">Curaçao</li>
                                        <li data-value="Cyprus">Cyprus</li>
                                        <li data-value="Czechia">Czechia</li>
                                        <li data-value="Côte d'Ivoire">Côte d'Ivoire</li>
                                        <li data-value="Denmark">Denmark</li>
                                        <li data-value="Djibouti">Djibouti</li>
                                        <li data-value="Dominica">Dominica</li>
                                        <li data-value="Dominican Republic (the)">Dominican Republic (the)</li>
                                        <li data-value="Ecuador">Ecuador</li>
                                        <li data-value="Egypt">Egypt</li>
                                        <li data-value="El Salvador">El Salvador</li>
                                        <li data-value="Equatorial Guinea">Equatorial Guinea</li>
                                        <li data-value="Eritrea">Eritrea</li>
                                        <li data-value="Estonia">Estonia</li>
                                        <li data-value="Eswatini">Eswatini</li>
                                        <li data-value="Ethiopia">Ethiopia</li>
                                        <li data-value="Falkland Islands (the) [Malvinas]">Falkland Islands (the)
                                            [Malvinas]</li>
                                        <li data-value="Faroe Islands (the)">Faroe Islands (the)</li>
                                        <li data-value="Fiji">Fiji</li>
                                        <li data-value="Finland">Finland</li>
                                        <li data-value="France">France</li>
                                        <li data-value="French Guiana">French Guiana</li>
                                        <li data-value="French Polynesia">French Polynesia</li>
                                        <li data-value="French Southern Territories (the)">French Southern Territories
                                            (the)</li>
                                        <li data-value="Gabon">Gabon</li>
                                        <li data-value="Gambia (the)">Gambia (the)</li>
                                        <li data-value="Georgia">Georgia</li>
                                        <li data-value="Germany">Germany</li>
                                        <li data-value="Ghana">Ghana</li>
                                        <li data-value="Gibraltar">Gibraltar</li>
                                        <li data-value="Greece">Greece</li>
                                        <li data-value="Greenland">Greenland</li>
                                        <li data-value="Grenada">Grenada</li>
                                        <li data-value="Guadeloupe">Guadeloupe</li>
                                        <li data-value="Guam">Guam</li>
                                        <li data-value="Guatemala">Guatemala</li>
                                        <li data-value="Guernsey">Guernsey</li>
                                        <li data-value="Guinea">Guinea</li>
                                        <li data-value="Guinea-Bissau">Guinea-Bissau</li>
                                        <li data-value="Guyana">Guyana</li>
                                        <li data-value="Haiti">Haiti</li>
                                        <li data-value="Heard Island and McDonald Islands">Heard Island and McDonald
                                            Islands</li>
                                        <li data-value="Holy See (the)">Holy See (the)</li>
                                        <li data-value="Honduras">Honduras</li>
                                        <li data-value="Hong Kong">Hong Kong</li>
                                        <li data-value="Hungary">Hungary</li>
                                        <li data-value="Iceland">Iceland</li>
                                        <li data-value="Indonesia">Indonesia</li>
                                        <li data-value="Iran (Islamic Republic of)">Iran (Islamic Republic of)</li>
                                        <li data-value="Iraq">Iraq</li>
                                        <li data-value="Ireland">Ireland</li>
                                        <li data-value="Isle of Man">Isle of Man</li>
                                        <li data-value="Israel">Israel</li>
                                        <li data-value="Italy">Italy</li>
                                        <li data-value="Jamaica">Jamaica</li>
                                        <li data-value="Japan">Japan</li>
                                        <li data-value="Jersey">Jersey</li>
                                        <li data-value="Jordan">Jordan</li>
                                        <li data-value="Kazakhstan">Kazakhstan</li>
                                        <li data-value="Kenya">Kenya</li>
                                        <li data-value="Kiribati">Kiribati</li>
                                        <li data-value="Korea (the Democratic People's Republic of)">Korea (the
                                            Democratic People's Republic of)</li>
                                        <li data-value="Korea (the Republic of)">Korea (the Republic of)</li>
                                        <li data-value="Kuwait">Kuwait</li>
                                        <li data-value="Kyrgyzstan">Kyrgyzstan</li>
                                        <li data-value="Lao People's Democratic Republic (the)">Lao People's Democratic
                                            Republic (the)</li>
                                        <li data-value="Latvia">Latvia</li>
                                        <li data-value="Lebanon">Lebanon</li>
                                        <li data-value="Lesotho">Lesotho</li>
                                        <li data-value="Liberia">Liberia</li>
                                        <li data-value="Libya">Libya</li>
                                        <li data-value="Liechtenstein">Liechtenstein</li>
                                        <li data-value="Lithuania">Lithuania</li>
                                        <li data-value="Luxembourg">Luxembourg</li>
                                        <li data-value="Macao">Macao</li>
                                        <li data-value="Madagascar">Madagascar</li>
                                        <li data-value="Malawi">Malawi</li>
                                        <li data-value="Malaysia">Malaysia</li>
                                        <li data-value="Maldives">Maldives</li>
                                        <li data-value="Mali">Mali</li>
                                        <li data-value="Malta">Malta</li>
                                        <li data-value="Marshall Islands (the)">Marshall Islands (the)</li>
                                        <li data-value="Martinique">Martinique</li>
                                        <li data-value="Mauritania">Mauritania</li>
                                        <li data-value="Mauritius">Mauritius</li>
                                        <li data-value="Mayotte">Mayotte</li>
                                        <li data-value="Mexico">Mexico</li>
                                        <li data-value="Micronesia (Federated States of)">Micronesia (Federated States
                                            of)</li>
                                        <li data-value="Moldova (the Republic of)">Moldova (the Republic of)</li>
                                        <li data-value="Monaco">Monaco</li>
                                        <li data-value="Mongolia">Mongolia</li>
                                        <li data-value="Montenegro">Montenegro</li>
                                        <li data-value="Montserrat">Montserrat</li>
                                        <li data-value="Morocco">Morocco</li>
                                        <li data-value="Mozambique">Mozambique</li>
                                        <li data-value="Namibia">Namibia</li>
                                        <li data-value="Nauru">Nauru</li>
                                        <li data-value="Netherlands (the)">Netherlands (the)</li>
                                        <li data-value="New Caledonia">New Caledonia</li>
                                        <li data-value="New Zealand">New Zealand</li>
                                        <li data-value="Nicaragua">Nicaragua</li>
                                        <li data-value="Niger (the)">Niger (the)</li>
                                        <li data-value="Nigeria">Nigeria</li>
                                        <li data-value="Niue">Niue</li>
                                        <li data-value="Norfolk Island">Norfolk Island</li>
                                        <li data-value="Northern Mariana Islands (the)">Northern Mariana Islands (the)
                                        </li>
                                        <li data-value="Norway">Norway</li>
                                        <li data-value="Oman">Oman</li>
                                        <li data-value="Palau">Palau</li>
                                        <li data-value="Palestine, State of">Palestine, State of</li>
                                        <li data-value="Panama">Panama</li>
                                        <li data-value="Papua New Guinea">Papua New Guinea</li>
                                        <li data-value="Paraguay">Paraguay</li>
                                        <li data-value="Peru">Peru</li>
                                        <li data-value="Philippines (the)">Philippines (the)</li>
                                        <li data-value="Pitcairn">Pitcairn</li>
                                        <li data-value="Poland">Poland</li>
                                        <li data-value="Portugal">Portugal</li>
                                        <li data-value="Puerto Rico">Puerto Rico</li>
                                        <li data-value="Qatar">Qatar</li>
                                        <li data-value="Republic of North Macedonia">Republic of North Macedonia</li>
                                        <li data-value="Romania">Romania</li>
                                        <li data-value="Russian Federation (the)">Russian Federation (the)</li>
                                        <li data-value="Rwanda">Rwanda</li>
                                        <li data-value="Réunion">Réunion</li>
                                        <li data-value="Saint Barthélemy">Saint Barthélemy</li>
                                        <li data-value="Saint Helena, Ascension and Tristan da Cunha">Saint Helena,
                                            Ascension and Tristan da Cunha</li>
                                        <li data-value="Saint Kitts and Nevis">Saint Kitts and Nevis</li>
                                        <li data-value="Saint Lucia">Saint Lucia</li>
                                        <li data-value="Saint Martin (French part)">Saint Martin (French part)</li>
                                        <li data-value="Saint Pierre and Miquelon">Saint Pierre and Miquelon</li>
                                        <li data-value="Saint Vincent and the Grenadines">Saint Vincent and the
                                            Grenadines</li>
                                        <li data-value="Samoa">Samoa</li>
                                        <li data-value="San Marino">San Marino</li>
                                        <li data-value="Sao Tome and Principe">Sao Tome and Principe</li>
                                        <li data-value="Saudi Arabia">Saudi Arabia</li>
                                        <li data-value="Senegal">Senegal</li>
                                        <li data-value="Serbia">Serbia</li>
                                        <li data-value="Seychelles">Seychelles</li>
                                        <li data-value="Sierra Leone">Sierra Leone</li>
                                        <li data-value="Singapore">Singapore</li>
                                        <li data-value="Sint Maarten (Dutch part)">Sint Maarten (Dutch part)</li>
                                        <li data-value="Slovakia">Slovakia</li>
                                        <li data-value="Slovenia">Slovenia</li>
                                        <li data-value="Solomon Islands">Solomon Islands</li>
                                        <li data-value="Somalia">Somalia</li>
                                        <li data-value="South Africa">South Africa</li>
                                        <li data-value="South Georgia and the South Sandwich Islands">South Georgia and
                                            the South Sandwich Islands</li>
                                        <li data-value="South Sudan">South Sudan</li>
                                        <li data-value="Spain">Spain</li>
                                        <li data-value="Sri Lanka">Sri Lanka</li>
                                        <li data-value="Sudan (the)">Sudan (the)</li>
                                        <li data-value="Suriname">Suriname</li>
                                        <li data-value="Svalbard and Jan Mayen">Svalbard and Jan Mayen</li>
                                        <li data-value="Sweden">Sweden</li>
                                        <li data-value="Switzerland">Switzerland</li>
                                        <li data-value="Syrian Arab Republic">Syrian Arab Republic</li>
                                        <li data-value="Taiwan">Taiwan</li>
                                        <li data-value="Tajikistan">Tajikistan</li>
                                        <li data-value="Tanzania, United Republic of">Tanzania, United Republic of</li>
                                        <li data-value="Thailand">Thailand</li>
                                        <li data-value="Timor-Leste">Timor-Leste</li>
                                        <li data-value="Togo">Togo</li>
                                        <li data-value="Tokelau">Tokelau</li>
                                        <li data-value="Tonga">Tonga</li>
                                        <li data-value="Trinidad and Tobago">Trinidad and Tobago</li>
                                        <li data-value="Tunisia">Tunisia</li>
                                        <li data-value="Turkey">Turkey</li>
                                        <li data-value="Turkmenistan">Turkmenistan</li>
                                        <li data-value="Turks and Caicos Islands (the)">Turks and Caicos Islands (the)
                                        </li>
                                        <li data-value="Tuvalu">Tuvalu</li>
                                        <li data-value="Uganda">Uganda</li>
                                        <li data-value="Ukraine">Ukraine</li>
                                        <li data-value="United Arab Emirates (the)">United Arab Emirates (the)</li>
                                        <li data-value="United Kingdom of Great Britain and Northern Ireland (the)">
                                            United Kingdom of Great Britain and Northern Ireland (the)</li>
                                        <li data-value="United States Minor Outlying Islands (the)">United States Minor
                                            Outlying Islands (the)</li>
                                        <li data-value="United States of America (the)">United States of America (the)
                                        </li>
                                        <li data-value="Uruguay">Uruguay</li>
                                        <li data-value="Uzbekistan">Uzbekistan</li>
                                        <li data-value="Vanuatu">Vanuatu</li>
                                        <li data-value="Venezuela (Bolivarian Republic of)">Venezuela (Bolivarian
                                            Republic of)</li>
                                        <li data-value="Viet Nam">Viet Nam</li>
                                        <li data-value="Virgin Islands (British)">Virgin Islands (British)</li>
                                        <li data-value="Virgin Islands (U.S.)">Virgin Islands (U.S.)</li>
                                        <li data-value="Wallis and Futuna">Wallis and Futuna</li>
                                        <li data-value="Western Sahara">Western Sahara</li>
                                        <li data-value="Yemen">Yemen</li>
                                        <li data-value="Zambia">Zambia</li>
                                        <li data-value="Zimbabwe">Zimbabwe</li>
                                        <li data-value="Åland Islands">Åland Islands</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="form-submit">
                                <button type="submit" class="form-btn">Submit</button>
                                <div class="form-btn callback-show-form-btn">Fill out the form</div>
                            </div>
                        </form>
                        <!--                    </div>-->

                        <!--                    <div class="callback-content__show-form form-btn callback-show-form-btn">Fill out the form</div>-->
                    </div>
                </div>
            </div>
        </section>

        <section id="check-your-manager" class="container">
            <div class="check-your-manager">
                <div>
                    <h2>Check your manager</h2>
                    <p>Please enter the Telegram handle (@username) of the employee you’ve communicated with. We will
                        verify whether they are an official representative of our company.</p>
                </div>

                <form class="check-your-manager__form">
                    <div>
                        <input class="form-input" type="text" name="tg-username" placeholder="@username">
                        <ul class="check-your-manager__form--input-error" style="display: none;">
                            <li>Starts with the symbol @</li>
                            <li>Length from 5 to 32 characters (after the @ sign)</li>
                            <li>Latin letters (a-z, A-Z)</li>
                            <li>Digits (0-9)</li>
                            <li>Underscore symbol (_)</li>
                        </ul>
                    </div>

                    <button class="form-btn" type="submit">Send</button>

                    <div class="base-tag red check-your-manager__form--message" style="display: none;">
                    </div>
                </form>
            </div>
        </section>

        <footer class="app-footer">
            <div class="container">
                <div class="footer-row">
                    <div class="footer-logo">
                        <a href="/">
                            <img src="<?php echo e(asset('assets/frontend/img')); ?>/logo.svg" alt="Swap.paykassma" width="187" height="24">
                        </a>
                    </div>

                    <div class="footer-copyright">Copyright © 2025 Swap.paykassma. All rights reserved.</div>

                    <div class="footer-telegram">
                        <a href="#" class="url_telegram_bot btn btn-sm"
                            target="_blank">
                            <span><img src="<?php echo e(asset('assets/frontend/img')); ?>/telegram.svg" alt="">Contact us in
                                Telegram</span>
                        </a>
                    </div>

                    <div class="footer-lang">
                        <div class="header-lang">
                            <button class="current-lang">
                                <img src="<?php echo e(asset('assets/frontend/img')); ?>/en.svg">
                                EN
                            </button>

                            <div class="header-lang-dropdown">
                                <a href="/" class="active lang-link">
                                    <img src="<?php echo e(asset('assets/frontend/img')); ?>/en.svg">
                                    EN
                                </a>
                                <a href="/ne" class="lang-link">
                                    <img src="<?php echo e(asset('assets/frontend/img')); ?>/ne.svg">
                                    NE
                                </a>
                                <a href="/bn" class="lang-link">
                                    <img src="<?php echo e(asset('assets/frontend/img')); ?>/bn.svg">
                                    BN
                                </a>
                                <a href="/si" class="lang-link">
                                    <img src="<?php echo e(asset('assets/frontend/img')); ?>/si.svg">
                                    SI
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <script>
        function handleSubmitForm(form) {
            console.log(form)
            const inputs = form.querySelectorAll('input')
            const data = {
                full_name: inputs[0].value,
                email: inputs[1].value,
                phone_number: inputs[2].value,
                telegram_username: inputs[3].value,
                country: inputs[4].value,
            }
            console.log(data)
        }
    </script>

    <script src="<?php echo e(asset('assets/frontend/js')); ?>/app.min.js"></script>


</body>

</html>
<?php /**PATH C:\laragon\www\123456\resources\views\index.blade.php ENDPATH**/ ?>